using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace SOFTIMAGE_XNAViewer
{
	public class RenderShape
	{
		private Vector3 position;
		private Model model;
        private String modelAsset;

		public Vector3 Position
		{
			get { return position; }
			set { position = value; }
		}

        [ContentSerializerIgnore]
		public Model Model
		{
			get { return model; }
			set { model = value; }
		}
        
        public string ModelAsset
        {
            get { return modelAsset; }
            set { modelAsset = value; }
        }

		public RenderShape()
		{			
		}

        public void Load(ContentManager content)
        {
            model = content.Load<Model>(modelAsset);
        }
	}
}
