using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace SOFTIMAGE_XNAViewer
{
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content
    /// Pipeline to read the specified data type from binary .xnb format.
    /// 
    /// Unlike the other Content Pipeline support classes, this should
    /// be a part of your main game project, and not the Content Pipeline
    /// Extension Library project.
    /// </summary>
    public class RenderShapeContentReader : ContentTypeReader<RenderShape>
    {
        protected override RenderShape Read(ContentReader input, RenderShape existingInstance)
        {
            RenderShape model = new RenderShape();
            model.ModelAsset = input.ReadString();
            model.Position = input.ReadVector3();
            model.Load(input.ContentManager);

            return model;
        }
    }
}