
#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using XSIXNARuntime;
#endregion


namespace SOFTIMAGE_XNAViewer
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        float M_PI = 3.141592f;
        float DEGTORAD = 0.01745329f;
        GraphicsDeviceManager graphics;
        ContentManager content;

        //private Model CrosswalkModel;
        private float m_FieldOfView;
        private Vector3 Position;
        private Vector3 Interest;
        //private bool PlaybackStatus = false;
		private List<RenderShape> models;
        //private int AnimationIndex = 0;
        //private int OldAnimationIndex = 0;
        //private List <XSIAnimationContent> Animations;
        private XSISASContainer SASData = new XSISASContainer();

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferMultiSampling = true;

            // use this for 720P
            //graphics.PreferredBackBufferWidth = 1280;
            //graphics.PreferredBackBufferHeight = 720;

            // for NTSC, use a 4:3 ratio
            graphics.PreferredBackBufferWidth = 720;
            graphics.PreferredBackBufferHeight = 480;

            content = new ContentManager(Services);
			models = new List<RenderShape>();
        }


        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            Position.X = 0.0f;
            Position.Y = 2.0f;
            Position.Z = 20.0f;

            Interest.X = 0.0f;
            Interest.Y = 0.0f;
            Interest.Z = 0.0f;

            m_FieldOfView = 90.0f;

            base.Initialize();

        }


        /// <summary>
        /// Load your graphics content.  If loadAllContent is true, you should
        /// load content from both ResourceManagementMode pools.  Otherwise, just
        /// load ResourceManagementMode.Manual content.
        /// </summary>
        /// <param name="loadAllContent">Which type of content to load.</param>
        protected override void LoadContent()
        {

          
         	// initialize lights by default
			XSISASPointLight light1 = new XSISASPointLight();
			XSISASPointLight light2 = new XSISASPointLight();
			XSISASPointLight light3 = new XSISASPointLight();

			light1.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);
			light2.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);
			light3.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);

			light1.Position = new Vector4(100.0f, 100.0f, 100.0f, 1.0f);
			light2.Position = new Vector4(-100.0f, 100.0f, 100.0f, 1.0f);
			light3.Position = new Vector4(0.0f, 0.0f, -100.0f, 1.0f);

			light1.Range = 10000.0f;
			light2.Range = 10000.0f;
			light3.Range = 10000.0f;

			SASData.PointLights.Add(light1);
			SASData.PointLights.Add(light2);
			SASData.PointLights.Add(light3);

            models = Content.Load<List<RenderShape>>("Content/Levels/test_level");				
        }

        


        private void Orbit(float dx, float dy)
        {
	        float       Ophi, rad, Otheta;
	        float       phi, theta, tmp;
	        Vector3     vct;

	        if ( dx == 0.0 && dy == 0.0 )
		        return;
           
	        //get vector from interest to position
	        vct = Position - Interest;   

	        //Get Length
            rad = vct.Length();

	        //IF length is too small, fail
	        if( Math.Abs(rad) < 0.000001f )
		        return;


	        if( (Math.Abs( vct.X ) < 0.000001f) && (Math.Abs( vct.Z ) < 0.000001f) )
		        phi = Ophi = 0.0f;
	        else
		        phi = Ophi = (float) Math.Atan2( vct.X, vct.Z );

	        //Get normlaized Y component
	        tmp = vct.Y / rad;

	        //Clamp it to -1.0/1.0
	        if (tmp < -1.0f) tmp = -1.0f;
	        if (tmp > 1.0f) tmp = 1.0f;

	        //calculate theta and otheta?
	        theta = Otheta = (float) Math.Acos( tmp );

	        //If there is some meovment in x, calculate phi
	        if ( dx != 0.0 )
	          phi = Ophi - dx;

	        //If there is some movement in y
	        if ( dy != 0.0 )
	        {
		        theta = Otheta + dy;
		        if( theta > M_PI - 0.01 )
			        theta = (float)(M_PI - 0.01f);
		        if( theta < 0.01 )
			        theta = 0.01f;
	        }

            vct.Z = (float)(rad * Math.Sin(theta) * Math.Cos(phi));
            vct.X = (float)(rad * Math.Sin(theta) * Math.Sin(phi));
            vct.Y = (float)(rad * Math.Cos(theta));
            vct += Interest ;

	        Position = vct;
        }


        void Dolly(float dx, float dy)
        {
            Vector3	    eye2int, vct;
	        float		delta;
        	
	        delta = dx + dy;

            //----------------------------------------------
            //  Compute the new position		    
            //----------------------------------------------
	        eye2int = Interest - Position;

            eye2int.Normalize();
	        vct = eye2int;

	        vct *= delta;    
            
            Position -= vct;
        }

        void Pan(float dx, float dy)
        {
            Vector3	    vctU, vctV, vctW, vctUV;
            float		len, scl;
        	
	        Vector3	vctCamPos = Position;
	        Vector3	vctCamInt = Interest;

            //--------------------------------------------------
            //  Create a UV vector of displacement.		
            //	The vctW point toward the interest, vctU is	
            //	a cross product between vctW and the UP vector.	
            //	vctV is the cross product between vctW and vctU	
            //	Both vctU and vctV are scaled to match the field
            //	of view.  The lenght in U is the width of the	
            //	window at the point of interest.		
            //--------------------------------------------------
	        vctW = vctCamInt - vctCamPos;
            
            len = vctW.Length();

    	    scl = (float)(len * Math.Tan( (m_FieldOfView * DEGTORAD) / 2.0f ) * 2.0f);

	        scl = (float) (Math.Abs(scl) * -1.0f);
	        vctW.Normalize();    

            //----------------------------------------------
            //  Get the U vector, WxUP			    
            //----------------------------------------------
            vctU = new Vector3(-vctW.Z, 0.0f, vctW.X);
	        vctU.Normalize();
            
            
            //----------------------------------------------
            //  Get the V vector			    
            //----------------------------------------------
	        vctV = Vector3.Cross(vctW, vctU);    
            
            //--------------------------------------------------
            //  Set the lenght of both vector to fit the window 
            //  A factor of 1.0 will move the interest in the	
            //	maximum position of the window			
            //--------------------------------------------------

            vctV.Normalize();
            vctU.Normalize();
	        vctV *= scl*dy;
	        vctU *= -scl * 1.0f * dx;    // todo add proper aspect ratio

            //----------------------------------------------
            //  Combine the two vectors and move the camera 
            //	position and interest.			    
            //----------------------------------------------
	        vctUV = vctU + vctV;
            
	        Position += vctUV;
	        Interest += vctUV;
        }


        private void UpdateGamePad()
        {
            GamePadState state = GamePad.GetState(PlayerIndex.One);

            if ((state.Buttons.Back == ButtonState.Pressed) && (state.Buttons.Start == ButtonState.Pressed))
                Exit();           

            if (state.Buttons.LeftStick == ButtonState.Pressed)
            {
                Position.X = 0.0f;
                Position.Y = 2.0f;
                Position.Z = 20.0f;

                Interest.X = 0.0f;
                Interest.Y = 0.0f;
                Interest.Z = 0.0f;

                m_FieldOfView = 45.0f;
            }            

            if (state.Triggers.Left > 0.5f) m_FieldOfView -= 1.0f;
            if (state.Triggers.Right > 0.5f) m_FieldOfView += 1.0f;

            if (m_FieldOfView < 1.0f) m_FieldOfView = 1.0f;
            if (m_FieldOfView > 179.0f) m_FieldOfView = 179.0f;

            Orbit(state.ThumbSticks.Left.X*0.1f, state.ThumbSticks.Left.Y*0.1f);
            Pan(state.ThumbSticks.Right.X * 0.1f, state.ThumbSticks.Right.Y * 0.1f);

            if (state.Buttons.LeftShoulder != 0)
                Dolly(-0.1f, 0.0f);
            if (state.Buttons.RightShoulder != 0)
                Dolly(0.1f, 0.0f);

        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // TODO: Add your update logic here
            UpdateGamePad();

           

            base.Update(gameTime);
        }

        private void DrawModel(Model m, Vector3 positionVector)
        {
            // post process animation
            XSIAnimationData l_Animations = m.Tag as XSIAnimationData;
			Matrix position = Matrix.CreateTranslation(positionVector);

            Matrix[] transforms = new Matrix[m.Bones.Count];

			/*for (int i = 0; i < m.Bones.Count; i++ )
				transforms[i] = transforms[i] * position;*/

            m.CopyAbsoluteBoneTransformsTo(transforms);
            l_Animations.ComputeBoneTransforms(transforms);

            Matrix[] bones = l_Animations.BoneTransforms;

            foreach (ModelMesh mesh in m.Meshes)
            {
				SASData.Model = transforms[mesh.ParentBone.Index] * position;
                SASData.ComputeModel();

                foreach (Effect effect in mesh.Effects)
                {


                    if (effect.GetType() == typeof(BasicEffect))
                    {
                        BasicEffect basiceffect = (BasicEffect)effect;
                        basiceffect.EnableDefaultLighting();
                        basiceffect.PreferPerPixelLighting = true;
                        basiceffect.Alpha = 0.5f;

                        basiceffect.View = SASData.View;
                        basiceffect.Projection = SASData.Projection;
                        basiceffect.World = SASData.Model;
                        mesh.Draw();
                    }
                    else
                    {
                        bool isSkinned = (bones.GetLength(0) > 0);
                        // set the technique
                        if (isSkinned && (effect.Techniques["Skinned"] != null))
                        {
                            effect.CurrentTechnique = effect.Techniques["Skinned"];
                        }
                        else
                        {
                            if (effect.Techniques["Static"] != null)
                            {
                                effect.CurrentTechnique = effect.Techniques["Static"];
                            }
                            else
                            {
                                effect.CurrentTechnique = effect.Techniques[0];
                            }
                        }

                        // bind bones
                        if ((effect.Parameters["Bones"] != null) && isSkinned)
                            effect.Parameters["Bones"].SetValue(bones);

                        // bind all other parameters
                        foreach (EffectParameter Parameter in effect.Parameters)
                        {
                            SASData.SetEffectParameterValue(Parameter);
                        }
                    }  
                }
                mesh.Draw();
 
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.Gray);

            // TODO: Add your drawing code here
            float aspectRatio = 1.3333333f; // graphics.GraphicsDevice.Viewport.Width / graphics.GraphicsDevice.Viewport.Height;

            SASData.Camera.NearFarClipping.X = 1.0f;
            SASData.Camera.NearFarClipping.Y = 10000.0f;
            SASData.Camera.Position.X = Position.X;
            SASData.Camera.Position.Y = Position.Y;
            SASData.Camera.Position.Z = Position.Z;
            SASData.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.ToRadians(m_FieldOfView), aspectRatio, SASData.Camera.NearFarClipping.X, SASData.Camera.NearFarClipping.Y);
            SASData.View = Matrix.CreateLookAt(Position, Interest, Vector3.Up);
            SASData.ComputeViewAndProjection();

			foreach(RenderShape shape in models)
				DrawModel(shape.Model, shape.Position);


            base.Draw(gameTime);
        }
    }
}